/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SetupProperties
extends Properties {
    public static final String PROP_XPORT_FIRMWARE = "firmware";
    public static final String PROP_XPORT_FIRMWARE_EN = "isFirmwareEnabled";
    public static final String PROP_INTERMEDIATE_FIRMWARE = "intFirmware";
    public static final String PROP_INTERMEDIATE_FIRMWARE_EN = "isIntFirmwareEn";
    public static final String PROP_WEB_CONTENT = "webIn";
    public static final String PROP_WEB_DEST_PATH = "webOutDir";
    public static final String PROP_WEB_CONTENT_EN = "isWebContentEnabled";
    public static final String PROP_NUM_WEB_FILES = "numWebFiles";
    public static final String VAL_ENABLED = "true";
    public static final String VAL_DISABLED = "false";
    public static final String DEFAULT_XPORT_FIRMWARE = "";
    public static final String DEFAULT_XPORT_FIRMWARE_EN = "false";
    public static final String DEFAULT_INTERMEDIATE_FIRMWARE = "xpt03dng.rom";
    public static final String DEFAULT_INTERMEDIATE_FIRMWARE_EN = "false";
    public static final String DEFAULT_WEB_CONTENT = "";
    public static final String DEFAULT_WEB_DEST_PATH = "";
    public static final String DEFAULT_WEB_CONTENT_EN = "false";
    public static final String DEFAULT_NUM_WEB_FILES = "0";
    private static SetupProperties inst_ = null;
    private static final String PROP_TEMP_WEB_FILE = "WebFile";
    private static final String PROP_TEMP_WEB_DEST = "WebDest";

    public static SetupProperties getInst() {
        if (inst_ == null) {
            inst_ = new SetupProperties();
            inst_.restoreDefaults();
        }
        return inst_;
    }

    protected SetupProperties() {
    }

    public void store() throws IOException {
        super.store(new FileOutputStream(SetupProperties.getPropsFile()), "BPME Setup Utility Properties");
    }

    public void load() throws IOException {
        super.load(new FileInputStream(SetupProperties.getPropsFile()));
    }

    public void loadAndRestore() {
        try {
            this.load();
        }
        catch (Exception exception) {
            this.restoreDefaults();
        }
    }

    public void restoreDefaults() {
        this.setProperty(PROP_XPORT_FIRMWARE, "");
        this.setProperty(PROP_INTERMEDIATE_FIRMWARE, DEFAULT_INTERMEDIATE_FIRMWARE);
        this.setProperty(PROP_XPORT_FIRMWARE_EN, "false");
        this.setProperty(PROP_INTERMEDIATE_FIRMWARE_EN, "false");
        this.setProperty(PROP_WEB_CONTENT, "");
        this.setProperty(PROP_WEB_DEST_PATH, "");
        this.setProperty(PROP_WEB_CONTENT_EN, "false");
        this.setProperty(PROP_NUM_WEB_FILES, DEFAULT_NUM_WEB_FILES);
    }

    public void setWebContentFileName(int n, String string, String string2) {
        int n2 = Integer.parseInt(this.getProperty(PROP_NUM_WEB_FILES));
        if (n < 0 || n >= n2) {
            return;
        }
        int n3 = n + 1;
        this.setProperty(PROP_TEMP_WEB_DEST + n3, string);
        this.setProperty(PROP_TEMP_WEB_FILE + n3, string2);
    }

    public String getWebContentFileDest(int n) {
        int n2 = Integer.parseInt(this.getProperty(PROP_NUM_WEB_FILES));
        if (n < 0 || n >= n2) {
            return "";
        }
        int n3 = n + 1;
        return this.getProperty(PROP_TEMP_WEB_DEST + n3, "");
    }

    public String getWebContentFileName(int n) {
        int n2 = Integer.parseInt(this.getProperty(PROP_NUM_WEB_FILES));
        if (n < 0 || n >= n2) {
            return "";
        }
        int n3 = n + 1;
        return this.getProperty(PROP_TEMP_WEB_FILE + n3, "");
    }

    protected static File getPropsFile() {
        return new File(System.getProperty("user.dir"), "setup.prop");
    }
}

